<?php if($campaigns->count() > 0): ?>
    <table class="table table-box pml-table mt-2"
        current-page="<?php echo e(empty(request()->page) ? 1 : empty(request()->page), false); ?>"
    >
        <?php $__currentLoopData = $campaigns; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $campaign): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <?php
                $debugInfo = $campaign->debug();
                $delayNote = $debugInfo['delay_note'] ?? '...';
            ?>

            <tr class="position-relative">
                <td width="1%" class="list-check-col">
                    <div class="text-nowrap">
                        <div class="checkbox inline me-1">
                            <label>
                                <input type="checkbox" class="node styled"
                                    name="uids[]"
                                    value="<?php echo e($campaign->uid, false); ?>"
                                />
                            </label>
                        </div>
                    </div>
                </td>
                <td>
                    <a class="kq_search fw-600 d-block list-title" href="<?php echo e(action('CampaignController@show', $campaign->uid), false); ?>">
                        <?php echo e($campaign->name, false); ?>

                    </a>
                    <span class="text-muted"><?php echo e(trans('messages.' . $campaign->type), false); ?></span>

                    <?php if($campaign->readCache('SubscriberCount')): ?>
                        <div>
                            <span class="text-semibold" data-popup="tooltip" title="<?php echo e($campaign->displayRecipients(), false); ?>">
                                <?php echo e(number_with_delimiter($campaign->readCache('SubscriberCount')), false); ?> <?php echo e(trans('messages.recipients'), false); ?>

                            </span>
                        </div>
                    <?php endif; ?>

                    <?php if($campaign->status != 'new' && isset($campaign->run_at)): ?>
                        <span class="text-muted2 d-block xtooltip" title="<?php echo e($campaign->scheduleDiffForHumans(), false); ?>"><?php echo e(trans('messages.run_at'), false); ?>: <span class="material-symbols-rounded">alarm</span>
                             <?php echo e(isset($campaign->run_at) ? Auth::user()->customer->formatDateTime($campaign->run_at, 'datetime_full') : "", false); ?></span>
                    <?php else: ?>
                        <span class="text-muted2 d-block"><?php echo e(trans('messages.updated_at'), false); ?>: <?php echo e(Auth::user()->customer->formatDateTime($campaign->created_at, 'datetime_full'), false); ?></span>
                    <?php endif; ?>
                </td>
                <?php if($campaign->status != 'new'): ?>
                    <td class="stat-fix-size-sm">
                        <div class="single-stat-box pull-left ml-4">
                            <span class="no-margin text-primary stat-num"><?php echo e($campaign->isSending() ? number_to_percentage($campaign->deliveredRate(true)) : number_to_percentage($campaign->readCache('DeliveredRate')), false); ?></span>
                            <div class="progress progress-xxs">
                                <div class="progress-bar progress-bar-info" style="width: <?php echo e($campaign->isSending() ? number_to_percentage($campaign->deliveredRate(true)) : number_to_percentage($campaign->readCache('DeliveredRate')), false); ?>">
                                </div>
                            </div>
                            <span class="text-semibold text-nowrap"><?php echo e($campaign->isSending() ? number_with_delimiter($campaign->deliveredCount()) : number_with_delimiter($campaign->readCache('DeliveredCount', 0)), false); ?> / <?php echo e(number_with_delimiter($campaign->readCache('SubscriberCount', 0)), false); ?></span>
                            <br />
                            <span class="text-muted"><?php echo e(trans('messages.sent'), false); ?></span>
                        </div>
                    </td>
                    <td class="stat-fix-size-sm">
                        <div class="single-stat-box pull-left ml-4">
                            <span class="no-margin text-primary stat-num"><?php echo e(number_to_percentage($campaign->readCache('UniqOpenRate')), false); ?></span>
                            <div class="progress progress-xxs">
                                <div class="progress-bar progress-bar-info" style="width: <?php echo e(number_to_percentage($campaign->readCache('UniqOpenRate')), false); ?>">
                                </div>
                            </div>
                            <span class="text-muted"><?php echo e(trans('messages.open_rate'), false); ?></span>
                        </div>
                    </td>
                    <td class="stat-fix-size-sm">
                        <div class="single-stat-box pull-left ml-4">
                            <span class="no-margin text-primary stat-num"><?php echo e(number_to_percentage($campaign->readCache('ClickedRate')), false); ?></span>
                            <div class="progress progress-xxs">
                                <div class="progress-bar progress-bar-info" style="width: <?php echo e(number_to_percentage($campaign->readCache('ClickedRate')), false); ?>">
                                </div>
                            </div>
                            <span class="text-muted"><?php echo e(trans('messages.click_rate'), false); ?></span>
                        </div>
                    </td>
                <?php else: ?>
                    <td></td>
                    <td></td>
                    <td></td>
                <?php endif; ?>
                <td width="15%" class="text-center">
                    <span class="text-muted2 list-status pull-left" title='<?php echo e($campaign->isError() ? $campaign->extractErrorMessage() : '', false); ?>' data-popup='tooltip'>
                        <span title="<?php echo e($campaign->isSending() ? $delayNote : '', false); ?>" class="label label-flat bg-<?php echo e($campaign->status, false); ?>"><?php echo e(trans('messages.campaign_status_' . $campaign->status), false); ?></span>
                    </span>
                    <pre style="display:none"><?php echo e($campaign->last_error, false); ?></pre>
                </td>
                <td class="text-end text-nowrap pe-0">
                    <div class="d-flex align-items-center text-nowrap justify-content-end">
                        <?php if(\Gate::allows('update', $campaign)): ?>
                            <a href="<?php echo e(action('CampaignController@edit', $campaign->uid), false); ?>" role="button"
                                class="btn btn-secondary btn-icon ms-1"> <span class="material-symbols-rounded">edit</span> <?php echo e(trans('messages.edit'), false); ?></a>
                        <?php endif; ?>
                        <?php if(\Gate::allows('overview', $campaign)): ?>
                            <a href="<?php echo e(action('CampaignController@overview', $campaign->uid), false); ?>" data-popup="tooltip"
                                title="<?php echo e(trans('messages.overview'), false); ?>" role="button"
                                class="btn btn-primary btn-icon ms-1"
                            >
                                <i class="icon-stats-growth"></i> <?php echo e(trans('messages.campaign.overview_statistics'), false); ?></a>
                        <?php endif; ?>
                        <?php if(\Gate::allows('delete', $campaign) || \Gate::allows('pause', $campaign) || \Gate::allows('resume', $campaign)): ?>
                            <div class="btn-group ms-1" role="group">
                                <button id="btnGroupDrop1" role="button" class="btn btn-light dropdown-toggle" data-bs-toggle="dropdown"></button>
                                <ul class="dropdown-menu dropdown-menu-end" aria-labelledby="btnGroupDrop1">
                                    <?php if(config('custom.dryrun')): ?>
                                        <li><a class="dropdown-item"
                                            href="<?php echo e(action('CampaignController@debug', ["uid" => $campaign->uid]), false); ?>">
                                            <span class="material-symbols-rounded me-2">assessment</span>Performance Report</a></li>
                                    <?php endif; ?>

                                    <?php if(\Gate::allows('resend', $campaign)): ?>
                                        <?php if(config('custom.japan') && !Acelle\Model\Setting::get('license')): ?>
                                            <li><a license-required class="dropdown-item" href="">
                                                <span class="material-symbols-rounded me-2">restart_alt</span> <?php echo e(trans("messages.campaign.resend"), false); ?></a></li>
                                        <?php else: ?>
                                            <li>
                                                <a class="dropdown-item resend-campaign"
                                                href="<?php echo e(action('CampaignController@resend', ["uid" => $campaign->uid]), false); ?>">
                                                <span class="material-symbols-rounded me-2">restart_alt</span> <?php echo e(trans("messages.campaign.resend"), false); ?></a></li>
                                        <?php endif; ?>
                                    <?php endif; ?>
                                    <?php if(\Gate::allows('send_test_email', $campaign)): ?>
                                        <?php if(config('custom.japan') && !Acelle\Model\Setting::get('license')): ?>
                                            <li><a license-required class="dropdown-item" href="">
                                                <span class="material-symbols-rounded me-2">forward_to_inbox</span> <?php echo e(trans("messages.send_a_test_email"), false); ?></a></li>
                                        <?php else: ?>
                                            <li><a class="dropdown-item send-a-test-email-link" href="<?php echo e(action('CampaignController@sendTestEmail', [
                                                'uid' => $campaign->uid,
                                            ]), false); ?>">
                                                <span class="material-symbols-rounded me-2">forward_to_inbox</span> <?php echo e(trans("messages.send_a_test_email"), false); ?></a></li>
                                        <?php endif; ?>
                                    <?php endif; ?>

                                    <?php if(\Gate::allows('pause', $campaign)): ?>
                                        <li><a class="dropdown-item list-action-single"
                                            link-method="POST"
                                            link-confirm="<?php echo e(trans('messages.pause_campaigns_confirm', ['number' => '1']), false); ?>"
                                            href="<?php echo e(action('CampaignController@pause', ["uids" => $campaign->uid]), false); ?>">
                                            <span class="material-symbols-rounded me-2">motion_photos_pause</span><?php echo e(trans("messages.pause"), false); ?></a></li>
                                    <?php endif; ?>
                                    <?php if(\Gate::allows('resume', $campaign)): ?>
                                        <?php if(config('custom.japan') && !Acelle\Model\Setting::get('license')): ?>
                                            <li><a license-required class="dropdown-item" href="">
                                                <span class="material-symbols-rounded me-2">restore</span> <?php echo e(trans("messages.resume"), false); ?></a></li>
                                        <?php else: ?>
                                            <li><a class="dropdown-item list-action-single"
                                                link-method="POST"
                                                link-confirm="<?php echo e(trans('messages.restart_campaigns_confirm', ['number' => '1']), false); ?>" href="<?php echo e(action('CampaignController@resume', ["uids" => $campaign->uid]), false); ?>">
                                                <span class="material-symbols-rounded me-2">restore</span> <?php echo e(trans("messages.resume"), false); ?></a></li>
                                        <?php endif; ?>
                                    <?php endif; ?>
                                    <?php if(\Gate::allows('resendHighPriority', $campaign)): ?>
                                        <li>
                                            <a class="dropdown-item list-action-single"
                                            link-method="POST"
                                            link-confirm="<?php echo e(trans('messages.restart_campaigns_confirm', ['number' => '1']), false); ?>"
                                            href="<?php echo e(action('CampaignController@resume', [
                                                'uids' => $campaign->uid,
                                                'queue' => 'high',
                                            ]), false); ?>">
                                            <span class="material-symbols-rounded me-2">restart_alt</span> <?php echo e(trans("messages.campaign.resume.high_priority"), false); ?></a></li>
                                    <?php endif; ?>
                                    <?php if(\Gate::allows('copy', $campaign)): ?>
                                        <li>
                                            <a class="copy-campaign-button dropdown-item"
                                                href="<?php echo e(action('CampaignController@copy', [
                                                    'uid' => $campaign->uid,
                                                    'copy_campaign_uid' => $campaign->uid,
                                                ]), false); ?>"
                                            >
                                                <span class="material-symbols-rounded me-2">copy_all</span> <?php echo e(trans('messages.copy'), false); ?>

                                            </a>
                                        </li>
                                    <?php endif; ?>
                                    <?php if(\Gate::allows('delete', $campaign)): ?>
                                        <li><a
                                            class="dropdown-item list-action-single"
                                            link-method="POST"
                                            link-confirm="<?php echo e(trans('messages.delete_campaign_confirm', ['name' => $campaign->name]), false); ?>"
                                            href="<?php echo e(action('CampaignController@delete', ["uids" => $campaign->uid]), false); ?>">
                                            <span class="material-symbols-rounded me-2">delete_outline</span> <?php echo e(trans("messages.delete"), false); ?></a></li>
                                    <?php endif; ?>
                                </ul>
                            </div>
                        <?php endif; ?>
                    </div>
                </td>
            </tr>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    </table>
    <?php echo $__env->make('elements/_per_page_select', ["items" => $campaigns], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

    <script>
        var CampaignsList = {
            copyPopup: null,

            getCopyPopup: function() {
                if (this.copyPopup === null) {
                    this.copyPopup = new Popup();
                }

                return this.copyPopup;
            }
        }

        var CampaignsResendPopup = {
            popup: null,

            load: function(url) {
                if (this.popup == null) {
                    this.popup = new Popup({
                        url: url
                    });
                }
                this.popup.load({
                    url: url
                });
            }
        }

        var CampaignsSendTestEmailPopup = {
            popup: null,

            load: function(url) {
                if (this.popup == null) {
                    this.popup = new Popup({
                        url: url
                    });
                }
                this.popup.load({
                    url: url
                });
            }
        }

        $('.resend-campaign').click(function(e) {
            e.preventDefault();

            var url = $(this).attr('href');

            CampaignsResendPopup.load(url);
        });

        $('.copy-campaign-button').on('click', function(e) {
            e.preventDefault();
            var url = $(this).attr('href');

            CampaignsList.getCopyPopup().load({
                url: url
            });
        });

        $('.send-a-test-email-link').on('click', function(e) {
            e.preventDefault();
            var url = $(this).attr('href');

            CampaignsSendTestEmailPopup.load(url);
        });
    </script>
<?php elseif(!empty(request()->keyword)): ?>
    <div class="empty-list">
        <span class="material-symbols-rounded">auto_awesome</span>
        <span class="line-1">
            <?php echo e(trans('messages.no_search_result'), false); ?>

        </span>
    </div>
<?php else: ?>
    <div class="empty-list">
        <span class="material-symbols-rounded">auto_awesome</span>
        <span class="line-1">
            <?php echo e(trans('messages.campaign_empty_line_1'), false); ?>

        </span>
    </div>
<?php endif; ?>
<?php /**PATH /home/wwalbe/comunicaciones.albertomerani.org/acellemail/resources/views/campaigns/_list.blade.php ENDPATH**/ ?>