<h2 class="mt-4 mb-4">
    <span class="text-teal text-bold"><?php echo e(number_with_delimiter($campaign->readCache('SubscriberCount', 0)), false); ?></span>
    <?php echo e(trans('messages.' . \Acelle\Library\Tool::getPluralPrase('recipient', $campaign->readCache('SubscriberCount', 0))), false); ?>

</h2>

<div class="row fs-7">
    <div class="col-md-6 campaigns-summary">
        <div class="mb-2">
            <span class="text-bold d-inline-block text-end pe-3" style="width:120px">
                <span class="label bg-light"><?php echo e(trans('messages.from'), false); ?> <span class="material-symbols-rounded">alternate_email</span></span>
            </span>
            <?php if($campaign->defaultMailList): ?>
                <a href="<?php echo e(action('MailListController@overview', ['uid' => $campaign->defaultMailList->uid]), false); ?>">
                    <?php echo $campaign->displayRecipients(); ?>

                </a>
            <?php else: ?>
                <?php echo $campaign->displayRecipients(); ?>

            <?php endif; ?>
        </div>
        <div class="mb-2">
            <span class="text-bold d-inline-block text-end pe-3" style="width:120px">
                <span class="label bg-light"><?php echo e(trans('messages.subject'), false); ?> <span class="material-symbols-rounded">subject</span></span></span>
            <?php echo e($campaign->subject, false); ?>

        </div>
        <div class="mb-2">
            <span class="text-bold d-inline-block text-end pe-3" style="width:120px">
                <span class="label bg-light"><?php echo e(trans('messages.from_email'), false); ?> <span class="material-symbols-rounded">alternate_email</span></span></span>
                    <a href="mailto:<?php echo e($campaign->from_email, false); ?>"><?php echo e($campaign->from_email, false); ?></a>
        </div>
        <div class="mb-2">
            <span class="text-bold d-inline-block text-end pe-3" style="width:120px">
                <span class="label bg-light"><?php echo e(trans('messages.from_name'), false); ?> <span class="material-symbols-rounded">subject</span></span></span>
            <?php echo e($campaign->from_name, false); ?>

        </div>

    </div>
    <div class="col-md-6">
        <div class="mb-2">
            <span class="text-bold d-inline-block text-end pe-3" style="width:120px">
                <span class="label bg-light"><?php echo e(trans('messages.reply_to'), false); ?> <span class="material-symbols-rounded">alternate_email</span></span></span>
            <a href="mailto:<?php echo e($campaign->reply_to, false); ?>"><?php echo e($campaign->reply_to, false); ?></a>
        </div>
        <div class="mb-2">
            <span class="text-bold d-inline-block text-end pe-3" style="width:120px">
                <span class="label bg-light"><?php echo e(trans('messages.updated_at'), false); ?> <span class="material-symbols-rounded">event</span></span></span>
            <?php echo e(Auth::user()->customer->formatDateTime($campaign->updated_at, 'datetime_full'), false); ?>

        </div>
        <div class="mb-2">
            <span class="text-bold d-inline-block text-end pe-3" style="width:120px">
                <span class="label bg-light"><?php echo e(trans('messages.run_at'), false); ?> <span class="material-symbols-rounded">event</span></span></span>
            <?php echo e(isset($campaign->run_at) ? Auth::user()->customer->formatDateTime($campaign->run_at, 'datetime_full') : "", false); ?>

        </div>
        <div class="mb-2">
            <span class="text-bold d-inline-block text-end pe-3" style="width:120px">
                <span class="label bg-light"><?php echo e(trans('messages.delivery_at'), false); ?> <span class="material-symbols-rounded">event</span></span></span>
            <?php echo e(isset($campaign->delivery_at) ? Auth::user()->customer->formatDateTime($campaign->delivery_at, 'datetime_full') : "", false); ?>

        </div>
    </div>
</div>
<?php /**PATH /home/wwalbe/comunicaciones.albertomerani.org/acellemail/resources/views/campaigns/_info.blade.php ENDPATH**/ ?>