<div class="row">
	<div class="col-md-12">
		<ul class="nav nav-tabs nav-tabs-top nav-underline">
			<li class="nav-item <?php echo e($menu == 'overview' ? 'active' : '', false); ?>">
				<a href="<?php echo e(action('CampaignController@overview', $campaign->uid), false); ?>" class="nav-link">
					<span class="material-symbols-rounded">auto_graph</span> <?php echo e(trans('messages.overview'), false); ?>

				</a>
			</li>
			<li class="nav-item <?php echo e($menu == 'links' ? 'active' : '', false); ?>">
				<a href="<?php echo e(action('CampaignController@links', $campaign->uid), false); ?>" class="nav-link">
					<span class="material-symbols-rounded">link</span> <?php echo e(trans('messages.links'), false); ?>

				</a>
			</li>
			<li class="nav-item <?php echo e($menu == 'open_map' ? 'active' : '', false); ?>">
				<a href="<?php echo e(action('CampaignController@openMap', $campaign->uid), false); ?>" class="nav-link">
					<span class="material-symbols-rounded">map</span> <?php echo e(trans('messages.open_map'), false); ?>

				</a>
			</li>
			<li class="nav-item <?php echo e($menu == 'subscribers' ? 'active' : '', false); ?>">
				<a href="<?php echo e(action('CampaignController@subscribers', $campaign->uid), false); ?>" class="nav-link">
					<span class="material-symbols-rounded">people_outline</span> <?php echo e(trans('messages.subscribers'), false); ?>

				</a>
			</li>
			<li class="nav-item <?php echo e(in_array($menu, [
				'tracking_log',
				'bounce_log',
				'feedback_log',
				'open_log',
				'click_log',
				'unsubscribe_log',
			]) ? 'active' : '', false); ?>">
				<a href="<?php echo e(action("AccountController@contact"), false); ?>" class="nav-link dropdown-toggle" data-bs-toggle="dropdown">
					<span class="material-symbols-rounded">article</span> <?php echo e(trans('messages.sending_logs'), false); ?>

					<span class="caret"></span>
				</a>
				<ul class="dropdown-menu">
					<li class="<?php echo e($menu == 'tracking_log' ? 'active' : '', false); ?>">
						<a class="dropdown-item" href="<?php echo e(action('CampaignController@trackingLog', $campaign->uid), false); ?>">
							<span class="material-symbols-rounded">article</span> <?php echo e(trans('messages.tracking_log'), false); ?>

						</a>
					</li>
					<li class="<?php echo e($menu == 'bounce_log' ? 'active' : '', false); ?>">
						<a class="dropdown-item" href="<?php echo e(action('CampaignController@bounceLog', $campaign->uid), false); ?>">
							<span class="material-symbols-rounded">article</span> <?php echo e(trans('messages.bounce_log'), false); ?>

						</a>
					</li>
					<li class="<?php echo e($menu == 'feedback_log' ? 'active' : '', false); ?>">
						<a class="dropdown-item" href="<?php echo e(action('CampaignController@feedbackLog', $campaign->uid), false); ?>">
							<span class="material-symbols-rounded">article</span> <?php echo e(trans('messages.feedback_log'), false); ?>

						</a>
					</li>
					<li class="<?php echo e($menu == 'open_log' ? 'active' : '', false); ?>">
						<a class="dropdown-item" href="<?php echo e(action('CampaignController@openLog', $campaign->uid), false); ?>">
							<span class="material-symbols-rounded">article</span> <?php echo e(trans('messages.open_log'), false); ?>

						</a>
					</li>
					<li class="<?php echo e($menu == 'click_log' ? 'active' : '', false); ?>">
						<a class="dropdown-item" href="<?php echo e(action('CampaignController@clickLog', $campaign->uid), false); ?>">
							<span class="material-symbols-rounded">article</span> <?php echo e(trans('messages.click_log'), false); ?>

						</a>
					</li>
					<li class="<?php echo e($menu == 'unsubscribe_log' ? 'active' : '', false); ?>">
						<a class="dropdown-item" href="<?php echo e(action('CampaignController@unsubscribeLog', $campaign->uid), false); ?>">
							<span class="material-symbols-rounded">article</span> <?php echo e(trans('messages.unsubscribe_log'), false); ?>

						</a>
					</li>
				</ul>
			</li>
			<li class="nav-item <?php echo e($menu == 'template' ? 'active' : '', false); ?>">
				<a href="javascript:;" onclick="popupwindow('<?php echo e(action('CampaignController@preview', $campaign->uid), false); ?>', `<?php echo e($campaign->name, false); ?>`, 800)" class="nav-link">
					<span class="material-symbols-rounded">auto_awesome_mosaic</span> <?php echo e(trans('messages.email_review'), false); ?>

				</a>
			</li>
		</ul>
	</div>
</div>

<script>
	var downloaded = false;
	var downloadWindow;

	function goToDownLoad(logtype) {
		downloadWindow = window.open('<?php echo e(action('CampaignController@trackingLogDownload', ['uid' => $campaign->uid]), false); ?>?logtype=' + logtype, '_blank');
	}

	function downloadAndCloseDownloadWindow(downloadUrl) {
		downloadWindow.close();
		window.location.href = downloadUrl;
	}
</script>
<?php /**PATH /home/wwalbe/comunicaciones.albertomerani.org/acellemail/resources/views/campaigns/_menu.blade.php ENDPATH**/ ?>