<h3 class="mt-5 mb-3"><span class="material-symbols-rounded me-2">drafts</span> <?php echo e(trans('messages.top_country_by_opens'), false); ?></h3>
<div class="row">
    <div class="col-md-6">
        <?php if(!$campaign->uniqueOpenCount()): ?>
            <div class="empty-chart-pie">
                <div class="empty-list">
                    <span class="material-symbols-rounded">auto_awesome</span>
                    <span class="line-1">
                        <?php echo e(trans('messages.log_empty_line_1'), false); ?>

                    </span>
                </div>
            </div>
        <?php else: ?>
            <div class="stat-table">
                <?php $__currentLoopData = $campaign->topOpenCountries(7)->get(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $location): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <div class="stat-row">
                        <p class="">
                            <img class="flag-icon" src="<?php echo e(url($location->getFlagPath()), false); ?>" />
                            <?php echo e($location->getCountryName(), false); ?>

                        </p>
                        <span class="pull-right num">
                            <?php echo e(number_with_delimiter($location->aggregate, $precision = 0), false); ?>

                        </span>
                    </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?> 
            </div>
            <div class="text-end">
                <a href="<?php echo e(action('CampaignController@openMap', $campaign->uid), false); ?>" class="btn btn-info bg-teal-600"><?php echo e(trans('messages.open_map'), false); ?> <span class="material-symbols-rounded">arrow_forward</span></a>
            </div>
        <?php endif; ?>
    </div>
    <div class="col-md-6">
        <?php if($campaign->uniqueOpenCount()): ?>
            <div class="border p-3 shadow-sm rounded">
                <div class="">
                    <div class="chart-container has-scroll">
                        <div class="chart has-fixed-height"
                            id="OpenPieChart" 
                            style="width:100%; height:350px;"
                            data-url="<?php echo e(action('CampaignController@chartCountry', $campaign->uid), false); ?>">
                        </div>
                    </div>
                </div>
            </div>
            
            <script>
                $(function() {
                    OpenPieChart.showChart();
                });
                var OpenPieChart = {
                    url: '<?php echo e(action('CampaignController@chartCountry', $campaign->uid), false); ?>',
                    getChart: function() {
                        return $('#OpenPieChart');
                    },
            
                    showChart: function() {
                        $.ajax({
                            method: "GET",
                            url: this.url,
                        })
                        .done(function( response ) {
                            OpenPieChart.renderChart( response.data );
                        });
                    },
            
                    renderChart: function(data) {
                        // based on prepared DOM, initialize echarts instance
                        var growthChart2 = echarts.init(OpenPieChart.getChart()[0], ECHARTS_THEME);

                        var colors = [
                            '#5cb2b2',
                            '#b25977',
                            '#aab25a',
                            '#5b7bb2',
                            '#555555',
                            '#626eb2',
                            '#81ac8d',
                            '#7d5fb2',
                            '#b26e59'
                        ];
            
                        var cData = data.map(function(item, index) {
                            return {
                                name: item.name,
                                value: item.value,
                                itemStyle: {
                                    color: colors[index],
                                    borderWidth: 1,  borderType: 'solid', borderColor: '#fff'
                                }
                            };
                        });
            
                        var option = {
                            title: {
                                text: '<?php echo e(trans('messages.countries'), false); ?>',
                                // subtext: '<?php echo e(trans('messages.statistics_chart'), false); ?>',
                                left: 'center'
                            },
                            tooltip: {
                                trigger: 'item',
                                formatter: '{b}: {c} ({d}%)'
                            },
                            legend: {
                                orient: 'vertical',
                                left: 'right',
                            },
                            series: [
                                {
                                    selectedMode: 'single',
                                    type: 'pie',
                                    radius: '70%',
                                    data: cData,
                                    emphasis: {
                                        itemStyle: {
                                            shadowBlur: 10,
                                            shadowOffsetX: 0,
                                            shadowColor: 'rgba(0, 0, 0, 0.5)'
                                        }
                                    },
                                    label: {
                                        // position: 'inner',
                                        fontSize: 12,
                                        color: ECHARTS_THEME == 'dark' ? '#fff' : null,
                                        formatter: '{b}\n{d}% ({c})',
                                    },
                                }
                            ]
                        };
            
                        // use configuration item and data specified to show chart
                        growthChart2.setOption(option);
                    }
                }    
            </script>
        <?php else: ?>
            <div class="empty-chart-pie">
                <div class="empty-list">
                    <span class="material-symbols-rounded">auto_awesome</span>
                    <span class="line-1">
                        <?php echo e(trans('messages.log_empty_line_1'), false); ?>

                    </span>
                </div>
            </div>
        <?php endif; ?>
    </div>                
</div><?php /**PATH /home/wwalbe/comunicaciones.albertomerani.org/acellemail/resources/views/campaigns/_most_open_country.blade.php ENDPATH**/ ?>